import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleSqlDatabaseInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the instance.
     *
     * If the name is left blank, Terraform will randomly generate one when the instance is first created. This is done because after a name is used, it cannot be reused for up to one week.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_database_instance.html#name DataGoogleSqlDatabaseInstance#name}
     */
    readonly name: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_database_instance.html#project DataGoogleSqlDatabaseInstance#project}
     */
    readonly project?: string;
}
export declare class DataGoogleSqlDatabaseInstanceClone extends cdktf.ComplexComputedList {
    get pointInTime(): string;
    get sourceInstanceName(): string;
}
export declare class DataGoogleSqlDatabaseInstanceIpAddress extends cdktf.ComplexComputedList {
    get ipAddress(): string;
    get timeToRetire(): string;
    get type(): string;
}
export declare class DataGoogleSqlDatabaseInstanceReplicaConfiguration extends cdktf.ComplexComputedList {
    get caCertificate(): string;
    get clientCertificate(): string;
    get clientKey(): string;
    get connectRetryInterval(): number;
    get dumpFilePath(): string;
    get failoverTarget(): any;
    get masterHeartbeatPeriod(): number;
    get password(): string;
    get sslCipher(): string;
    get username(): string;
    get verifyServerCertificate(): any;
}
export declare class DataGoogleSqlDatabaseInstanceRestoreBackupContext extends cdktf.ComplexComputedList {
    get backupRunId(): number;
    get instanceId(): string;
    get project(): string;
}
export declare class DataGoogleSqlDatabaseInstanceServerCaCert extends cdktf.ComplexComputedList {
    get cert(): string;
    get commonName(): string;
    get createTime(): string;
    get expirationTime(): string;
    get sha1Fingerprint(): string;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings extends cdktf.ComplexComputedList {
    get retainedBackups(): number;
    get retentionUnit(): string;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsBackupConfiguration extends cdktf.ComplexComputedList {
    get backupRetentionSettings(): any;
    get binaryLogEnabled(): any;
    get enabled(): any;
    get location(): string;
    get pointInTimeRecoveryEnabled(): any;
    get startTime(): string;
    get transactionLogRetentionDays(): number;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsDatabaseFlags extends cdktf.ComplexComputedList {
    get name(): string;
    get value(): string;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsInsightsConfig extends cdktf.ComplexComputedList {
    get queryInsightsEnabled(): any;
    get queryStringLength(): number;
    get recordApplicationTags(): any;
    get recordClientAddress(): any;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks extends cdktf.ComplexComputedList {
    get expirationTime(): string;
    get name(): string;
    get value(): string;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsIpConfiguration extends cdktf.ComplexComputedList {
    get authorizedNetworks(): any;
    get ipv4Enabled(): any;
    get privateNetwork(): string;
    get requireSsl(): any;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsLocationPreference extends cdktf.ComplexComputedList {
    get followGaeApplication(): string;
    get zone(): string;
}
export declare class DataGoogleSqlDatabaseInstanceSettingsMaintenanceWindow extends cdktf.ComplexComputedList {
    get day(): number;
    get hour(): number;
    get updateTrack(): string;
}
export declare class DataGoogleSqlDatabaseInstanceSettings extends cdktf.ComplexComputedList {
    get activationPolicy(): string;
    get authorizedGaeApplications(): string[];
    get availabilityType(): string;
    get backupConfiguration(): any;
    get collation(): string;
    get crashSafeReplication(): any;
    get databaseFlags(): any;
    get diskAutoresize(): any;
    get diskAutoresizeLimit(): number;
    get diskSize(): number;
    get diskType(): string;
    get insightsConfig(): any;
    get ipConfiguration(): any;
    get locationPreference(): any;
    get maintenanceWindow(): any;
    get pricingPlan(): string;
    get replicationType(): string;
    get tier(): string;
    get userLabels(): any;
    get version(): number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/sql_database_instance.html google_sql_database_instance}.
 */
export declare class DataGoogleSqlDatabaseInstance extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/sql_database_instance.html google_sql_database_instance} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleSqlDatabaseInstanceConfig);
    clone(index: string): DataGoogleSqlDatabaseInstanceClone;
    get connectionName(): string;
    get databaseVersion(): string;
    get deletionProtection(): any;
    get firstIpAddress(): string;
    get id(): string;
    ipAddress(index: string): DataGoogleSqlDatabaseInstanceIpAddress;
    get masterInstanceName(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get privateIpAddress(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get publicIpAddress(): string;
    get region(): string;
    replicaConfiguration(index: string): DataGoogleSqlDatabaseInstanceReplicaConfiguration;
    restoreBackupContext(index: string): DataGoogleSqlDatabaseInstanceRestoreBackupContext;
    get rootPassword(): string;
    get selfLink(): string;
    serverCaCert(index: string): DataGoogleSqlDatabaseInstanceServerCaCert;
    get serviceAccountEmailAddress(): string;
    settings(index: string): DataGoogleSqlDatabaseInstanceSettings;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
