import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleSqlCaCertsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_ca_certs.html#instance DataGoogleSqlCaCerts#instance}.
     */
    readonly instance: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_ca_certs.html#project DataGoogleSqlCaCerts#project}.
     */
    readonly project?: string;
}
export declare class DataGoogleSqlCaCertsCerts extends cdktf.ComplexComputedList {
    get cert(): string;
    get commonName(): string;
    get createTime(): string;
    get expirationTime(): string;
    get sha1Fingerprint(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/sql_ca_certs.html google_sql_ca_certs}.
 */
export declare class DataGoogleSqlCaCerts extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/sql_ca_certs.html google_sql_ca_certs} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleSqlCaCertsConfig);
    get activeVersion(): string;
    certs(index: string): DataGoogleSqlCaCertsCerts;
    get id(): string;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
