import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleSqlBackupRunConfig extends cdktf.TerraformMetaArguments {
    /**
     * The identifier for this backup run.
     *
     * Unique only for a specific Cloud SQL instance. If left empty and multiple backups exist for the instance, most_recent must be set to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_backup_run.html#backup_id DataGoogleSqlBackupRun#backup_id}
     */
    readonly backupId?: number;
    /**
     * Name of the database instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_backup_run.html#instance DataGoogleSqlBackupRun#instance}
     */
    readonly instance: string;
    /**
     * Toggles use of the most recent backup run if multiple backups exist for a Cloud SQL instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_backup_run.html#most_recent DataGoogleSqlBackupRun#most_recent}
     */
    readonly mostRecent?: boolean | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/sql_backup_run.html google_sql_backup_run}.
 */
export declare class DataGoogleSqlBackupRun extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/sql_backup_run.html google_sql_backup_run} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleSqlBackupRunConfig);
    private _backupId?;
    get backupId(): number | undefined;
    set backupId(value: number | undefined);
    resetBackupId(): void;
    get backupIdInput(): number | undefined;
    get id(): string;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    get location(): string;
    private _mostRecent?;
    get mostRecent(): boolean | cdktf.IResolvable | undefined;
    set mostRecent(value: boolean | cdktf.IResolvable | undefined);
    resetMostRecent(): void;
    get mostRecentInput(): boolean | cdktf.IResolvable | undefined;
    get startTime(): string;
    get status(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
