import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleSourcerepoRepositoryConfig extends cdktf.TerraformMetaArguments {
    /**
     * Resource name of the repository, of the form '{{repo}}'. The repo name may contain slashes. eg, 'name/with/slash'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sourcerepo_repository.html#name DataGoogleSourcerepoRepository#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sourcerepo_repository.html#project DataGoogleSourcerepoRepository#project}.
     */
    readonly project?: string;
}
export declare class DataGoogleSourcerepoRepositoryPubsubConfigs extends cdktf.ComplexComputedList {
    get messageFormat(): string;
    get serviceAccountEmail(): string;
    get topic(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/sourcerepo_repository.html google_sourcerepo_repository}.
 */
export declare class DataGoogleSourcerepoRepository extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/sourcerepo_repository.html google_sourcerepo_repository} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleSourcerepoRepositoryConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    pubsubConfigs(index: string): DataGoogleSourcerepoRepositoryPubsubConfigs;
    get size(): number;
    get url(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
