import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleServiceAccountKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_key.html#name DataGoogleServiceAccountKey#name}.
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_key.html#project DataGoogleServiceAccountKey#project}.
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_key.html#public_key_type DataGoogleServiceAccountKey#public_key_type}.
     */
    readonly publicKeyType?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/service_account_key.html google_service_account_key}.
 */
export declare class DataGoogleServiceAccountKey extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/service_account_key.html google_service_account_key} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleServiceAccountKeyConfig);
    get id(): string;
    get keyAlgorithm(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get publicKey(): string;
    private _publicKeyType?;
    get publicKeyType(): string | undefined;
    set publicKeyType(value: string | undefined);
    resetPublicKeyType(): void;
    get publicKeyTypeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
