import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleServiceAccountIdTokenConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_id_token.html#delegates DataGoogleServiceAccountIdToken#delegates}.
     */
    readonly delegates?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_id_token.html#include_email DataGoogleServiceAccountIdToken#include_email}.
     */
    readonly includeEmail?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_id_token.html#target_audience DataGoogleServiceAccountIdToken#target_audience}.
     */
    readonly targetAudience: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_id_token.html#target_service_account DataGoogleServiceAccountIdToken#target_service_account}.
     */
    readonly targetServiceAccount?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/service_account_id_token.html google_service_account_id_token}.
 */
export declare class DataGoogleServiceAccountIdToken extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/service_account_id_token.html google_service_account_id_token} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleServiceAccountIdTokenConfig);
    private _delegates?;
    get delegates(): string[] | undefined;
    set delegates(value: string[] | undefined);
    resetDelegates(): void;
    get delegatesInput(): string[] | undefined;
    get id(): string;
    get idToken(): string;
    private _includeEmail?;
    get includeEmail(): boolean | cdktf.IResolvable | undefined;
    set includeEmail(value: boolean | cdktf.IResolvable | undefined);
    resetIncludeEmail(): void;
    get includeEmailInput(): boolean | cdktf.IResolvable | undefined;
    private _targetAudience?;
    get targetAudience(): string;
    set targetAudience(value: string);
    get targetAudienceInput(): string | undefined;
    private _targetServiceAccount?;
    get targetServiceAccount(): string | undefined;
    set targetServiceAccount(value: string | undefined);
    resetTargetServiceAccount(): void;
    get targetServiceAccountInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
