import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleServiceAccountAccessTokenConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_access_token.html#delegates DataGoogleServiceAccountAccessToken#delegates}.
     */
    readonly delegates?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_access_token.html#lifetime DataGoogleServiceAccountAccessToken#lifetime}.
     */
    readonly lifetime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_access_token.html#scopes DataGoogleServiceAccountAccessToken#scopes}.
     */
    readonly scopes: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_access_token.html#target_service_account DataGoogleServiceAccountAccessToken#target_service_account}.
     */
    readonly targetServiceAccount: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/service_account_access_token.html google_service_account_access_token}.
 */
export declare class DataGoogleServiceAccountAccessToken extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/service_account_access_token.html google_service_account_access_token} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleServiceAccountAccessTokenConfig);
    get accessToken(): string;
    private _delegates?;
    get delegates(): string[] | undefined;
    set delegates(value: string[] | undefined);
    resetDelegates(): void;
    get delegatesInput(): string[] | undefined;
    get id(): string;
    private _lifetime?;
    get lifetime(): string | undefined;
    set lifetime(value: string | undefined);
    resetLifetime(): void;
    get lifetimeInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    get scopesInput(): string[] | undefined;
    private _targetServiceAccount?;
    get targetServiceAccount(): string;
    set targetServiceAccount(value: string);
    get targetServiceAccountInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
