import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleSecretManagerSecretVersionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/secret_manager_secret_version.html#project DataGoogleSecretManagerSecretVersion#project}.
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/secret_manager_secret_version.html#secret DataGoogleSecretManagerSecretVersion#secret}.
     */
    readonly secret: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/secret_manager_secret_version.html#version DataGoogleSecretManagerSecretVersion#version}.
     */
    readonly version?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/secret_manager_secret_version.html google_secret_manager_secret_version}.
 */
export declare class DataGoogleSecretManagerSecretVersion extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/secret_manager_secret_version.html google_secret_manager_secret_version} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleSecretManagerSecretVersionConfig);
    get createTime(): string;
    get destroyTime(): string;
    get enabled(): any;
    get id(): string;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _secret?;
    get secret(): string;
    set secret(value: string);
    get secretInput(): string | undefined;
    get secretData(): string;
    private _version?;
    get version(): string | undefined;
    set version(value: string | undefined);
    resetVersion(): void;
    get versionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
