import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleRedisInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The ID of the instance or a fully qualified identifier for the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/redis_instance.html#name DataGoogleRedisInstance#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/redis_instance.html#project DataGoogleRedisInstance#project}.
     */
    readonly project?: string;
    /**
     * The name of the Redis region of the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/redis_instance.html#region DataGoogleRedisInstance#region}
     */
    readonly region?: string;
}
export declare class DataGoogleRedisInstanceServerCaCerts extends cdktf.ComplexComputedList {
    get cert(): string;
    get createTime(): string;
    get expireTime(): string;
    get serialNumber(): string;
    get sha1Fingerprint(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/redis_instance.html google_redis_instance}.
 */
export declare class DataGoogleRedisInstance extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/redis_instance.html google_redis_instance} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleRedisInstanceConfig);
    get alternativeLocationId(): string;
    get authEnabled(): any;
    get authString(): string;
    get authorizedNetwork(): string;
    get connectMode(): string;
    get createTime(): string;
    get currentLocationId(): string;
    get displayName(): string;
    get host(): string;
    get id(): string;
    labels(key: string): string;
    get locationId(): string;
    get memorySizeGb(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get persistenceIamIdentity(): string;
    get port(): number;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    redisConfigs(key: string): string;
    get redisVersion(): string;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get reservedIpRange(): string;
    serverCaCerts(index: string): DataGoogleRedisInstanceServerCaCerts;
    get tier(): string;
    get transitEncryptionMode(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
