import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleProjectsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/projects.html#filter DataGoogleProjects#filter}.
     */
    readonly filter: string;
}
export declare class DataGoogleProjectsProjects extends cdktf.ComplexComputedList {
    get createTime(): string;
    get labels(): any;
    get lifecycleState(): string;
    get name(): string;
    get number(): string;
    get parent(): any;
    get projectId(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/projects.html google_projects}.
 */
export declare class DataGoogleProjects extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/projects.html google_projects} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleProjectsConfig);
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
    get id(): string;
    projects(index: string): DataGoogleProjectsProjects;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
