import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleProjectOrganizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Constraint the Policy is configuring, for example, serviceuser.services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/project_organization_policy.html#constraint DataGoogleProjectOrganizationPolicy#constraint}
     */
    readonly constraint: string;
    /**
     * The project ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/project_organization_policy.html#project DataGoogleProjectOrganizationPolicy#project}
     */
    readonly project: string;
}
export declare class DataGoogleProjectOrganizationPolicyBooleanPolicy extends cdktf.ComplexComputedList {
    get enforced(): any;
}
export declare class DataGoogleProjectOrganizationPolicyListPolicyAllow extends cdktf.ComplexComputedList {
    get all(): any;
    get values(): string[];
}
export declare class DataGoogleProjectOrganizationPolicyListPolicyDeny extends cdktf.ComplexComputedList {
    get all(): any;
    get values(): string[];
}
export declare class DataGoogleProjectOrganizationPolicyListPolicy extends cdktf.ComplexComputedList {
    get allow(): any;
    get deny(): any;
    get inheritFromParent(): any;
    get suggestedValue(): string;
}
export declare class DataGoogleProjectOrganizationPolicyRestorePolicy extends cdktf.ComplexComputedList {
    get default(): any;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/project_organization_policy.html google_project_organization_policy}.
 */
export declare class DataGoogleProjectOrganizationPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/project_organization_policy.html google_project_organization_policy} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleProjectOrganizationPolicyConfig);
    booleanPolicy(index: string): DataGoogleProjectOrganizationPolicyBooleanPolicy;
    private _constraint?;
    get constraint(): string;
    set constraint(value: string);
    get constraintInput(): string | undefined;
    get etag(): string;
    get id(): string;
    listPolicy(index: string): DataGoogleProjectOrganizationPolicyListPolicy;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    restorePolicy(index: string): DataGoogleProjectOrganizationPolicyRestorePolicy;
    get updateTime(): string;
    get version(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
