import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleOrganizationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/organization.html#domain DataGoogleOrganization#domain}.
     */
    readonly domain?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/organization.html#organization DataGoogleOrganization#organization}.
     */
    readonly organization?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/organization.html google_organization}.
 */
export declare class DataGoogleOrganization extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/organization.html google_organization} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: DataGoogleOrganizationConfig);
    get createTime(): string;
    get directoryCustomerId(): string;
    private _domain?;
    get domain(): string | undefined;
    set domain(value: string | undefined);
    resetDomain(): void;
    get domainInput(): string | undefined;
    get id(): string;
    get lifecycleState(): string;
    get name(): string;
    get orgId(): string;
    private _organization?;
    get organization(): string | undefined;
    set organization(value: string | undefined);
    resetOrganization(): void;
    get organizationInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
