import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleMonitoringClusterIstioServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Kubernetes cluster in which this Istio service is defined.
     *
     * Corresponds to the clusterName resource label in k8s_cluster resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_cluster_istio_service.html#cluster_name DataGoogleMonitoringClusterIstioService#cluster_name}
     */
    readonly clusterName: string;
    /**
     * The location of the Kubernetes cluster in which this Istio service is defined.
     *
     * Corresponds to the location resource label in k8s_cluster resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_cluster_istio_service.html#location DataGoogleMonitoringClusterIstioService#location}
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_cluster_istio_service.html#project DataGoogleMonitoringClusterIstioService#project}.
     */
    readonly project?: string;
    /**
     * The name of the Istio service underlying this service.
     *
     * Corresponds to the destination_service_name metric label in Istio metrics.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_cluster_istio_service.html#service_name DataGoogleMonitoringClusterIstioService#service_name}
     */
    readonly serviceName: string;
    /**
     * The namespace of the Istio service underlying this service.
     *
     * Corresponds to the destination_service_namespace metric label in Istio metrics.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_cluster_istio_service.html#service_namespace DataGoogleMonitoringClusterIstioService#service_namespace}
     */
    readonly serviceNamespace: string;
}
export declare class DataGoogleMonitoringClusterIstioServiceTelemetry extends cdktf.ComplexComputedList {
    get resourceName(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/monitoring_cluster_istio_service.html google_monitoring_cluster_istio_service}.
 */
export declare class DataGoogleMonitoringClusterIstioService extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/monitoring_cluster_istio_service.html google_monitoring_cluster_istio_service} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleMonitoringClusterIstioServiceConfig);
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    get displayName(): string;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get serviceId(): string;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    get serviceNameInput(): string | undefined;
    private _serviceNamespace?;
    get serviceNamespace(): string;
    set serviceNamespace(value: string);
    get serviceNamespaceInput(): string | undefined;
    telemetry(index: string): DataGoogleMonitoringClusterIstioServiceTelemetry;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
