import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleMonitoringAppEngineServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The ID of the App Engine module underlying this service.
     *
     * Corresponds to the 'moduleId' resource label for a 'gae_app'
     * monitored resource(see https://cloud.google.com/monitoring/api/resources#tag_gae_app)
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_app_engine_service.html#module_id DataGoogleMonitoringAppEngineService#module_id}
     */
    readonly moduleId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_app_engine_service.html#project DataGoogleMonitoringAppEngineService#project}.
     */
    readonly project?: string;
}
export declare class DataGoogleMonitoringAppEngineServiceTelemetry extends cdktf.ComplexComputedList {
    get resourceName(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/monitoring_app_engine_service.html google_monitoring_app_engine_service}.
 */
export declare class DataGoogleMonitoringAppEngineService extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/monitoring_app_engine_service.html google_monitoring_app_engine_service} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleMonitoringAppEngineServiceConfig);
    get displayName(): string;
    get id(): string;
    private _moduleId?;
    get moduleId(): string;
    set moduleId(value: string);
    get moduleIdInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get serviceId(): string;
    telemetry(index: string): DataGoogleMonitoringAppEngineServiceTelemetry;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
