import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleKmsCryptoKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The KeyRing that this key belongs to. Format: ''projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}''.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_crypto_key.html#key_ring DataGoogleKmsCryptoKey#key_ring}
     */
    readonly keyRing: string;
    /**
     * The resource name for the CryptoKey.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_crypto_key.html#name DataGoogleKmsCryptoKey#name}
     */
    readonly name: string;
}
export declare class DataGoogleKmsCryptoKeyVersionTemplate extends cdktf.ComplexComputedList {
    get algorithm(): string;
    get protectionLevel(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/kms_crypto_key.html google_kms_crypto_key}.
 */
export declare class DataGoogleKmsCryptoKey extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/kms_crypto_key.html google_kms_crypto_key} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleKmsCryptoKeyConfig);
    get destroyScheduledDuration(): string;
    get id(): string;
    get importOnly(): any;
    private _keyRing?;
    get keyRing(): string;
    set keyRing(value: string);
    get keyRingInput(): string | undefined;
    labels(key: string): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get purpose(): string;
    get rotationPeriod(): string;
    get selfLink(): string;
    get skipInitialVersionCreation(): any;
    versionTemplate(index: string): DataGoogleKmsCryptoKeyVersionTemplate;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
