import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleIamTestablePermissionsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_testable_permissions.html#custom_support_level DataGoogleIamTestablePermissions#custom_support_level}.
     */
    readonly customSupportLevel?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_testable_permissions.html#full_resource_name DataGoogleIamTestablePermissions#full_resource_name}.
     */
    readonly fullResourceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_testable_permissions.html#stages DataGoogleIamTestablePermissions#stages}.
     */
    readonly stages?: string[];
}
export declare class DataGoogleIamTestablePermissionsPermissions extends cdktf.ComplexComputedList {
    get apiDisabled(): any;
    get customSupportLevel(): string;
    get name(): string;
    get stage(): string;
    get title(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/iam_testable_permissions.html google_iam_testable_permissions}.
 */
export declare class DataGoogleIamTestablePermissions extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/iam_testable_permissions.html google_iam_testable_permissions} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleIamTestablePermissionsConfig);
    private _customSupportLevel?;
    get customSupportLevel(): string | undefined;
    set customSupportLevel(value: string | undefined);
    resetCustomSupportLevel(): void;
    get customSupportLevelInput(): string | undefined;
    private _fullResourceName?;
    get fullResourceName(): string;
    set fullResourceName(value: string);
    get fullResourceNameInput(): string | undefined;
    get id(): string;
    permissions(index: string): DataGoogleIamTestablePermissionsPermissions;
    private _stages?;
    get stages(): string[] | undefined;
    set stages(value: string[] | undefined);
    resetStages(): void;
    get stagesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
