import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleIamRoleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_role.html#name DataGoogleIamRole#name}.
     */
    readonly name: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/iam_role.html google_iam_role}.
 */
export declare class DataGoogleIamRole extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/iam_role.html google_iam_role} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleIamRoleConfig);
    get id(): string;
    get includedPermissions(): string[];
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get stage(): string;
    get title(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
