import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * audit_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#audit_config DataGoogleIamPolicy#audit_config}
     */
    readonly auditConfig?: DataGoogleIamPolicyAuditConfig[];
    /**
     * binding block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#binding DataGoogleIamPolicy#binding}
     */
    readonly binding?: DataGoogleIamPolicyBinding[];
}
export interface DataGoogleIamPolicyAuditConfigAuditLogConfigs {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#exempted_members DataGoogleIamPolicy#exempted_members}.
     */
    readonly exemptedMembers?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#log_type DataGoogleIamPolicy#log_type}.
     */
    readonly logType: string;
}
export interface DataGoogleIamPolicyAuditConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#service DataGoogleIamPolicy#service}.
     */
    readonly service: string;
    /**
     * audit_log_configs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#audit_log_configs DataGoogleIamPolicy#audit_log_configs}
     */
    readonly auditLogConfigs: DataGoogleIamPolicyAuditConfigAuditLogConfigs[];
}
export interface DataGoogleIamPolicyBindingCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#description DataGoogleIamPolicy#description}.
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#expression DataGoogleIamPolicy#expression}.
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#title DataGoogleIamPolicy#title}.
     */
    readonly title: string;
}
export declare class DataGoogleIamPolicyBindingConditionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
export interface DataGoogleIamPolicyBinding {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#members DataGoogleIamPolicy#members}.
     */
    readonly members: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#role DataGoogleIamPolicy#role}.
     */
    readonly role: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#condition DataGoogleIamPolicy#condition}
     */
    readonly condition?: DataGoogleIamPolicyBindingCondition;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html google_iam_policy}.
 */
export declare class DataGoogleIamPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html google_iam_policy} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: DataGoogleIamPolicyConfig);
    get id(): string;
    get policyData(): string;
    private _auditConfig?;
    get auditConfig(): DataGoogleIamPolicyAuditConfig[] | undefined;
    set auditConfig(value: DataGoogleIamPolicyAuditConfig[] | undefined);
    resetAuditConfig(): void;
    get auditConfigInput(): DataGoogleIamPolicyAuditConfig[] | undefined;
    private _binding?;
    get binding(): DataGoogleIamPolicyBinding[] | undefined;
    set binding(value: DataGoogleIamPolicyBinding[] | undefined);
    resetBinding(): void;
    get bindingInput(): DataGoogleIamPolicyBinding[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
