import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleGameServicesGameServerDeploymentRolloutConfig extends cdktf.TerraformMetaArguments {
    /**
     * The deployment to rollout the new config to. Only 1 rollout must be associated with each deployment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/game_services_game_server_deployment_rollout.html#deployment_id DataGoogleGameServicesGameServerDeploymentRollout#deployment_id}
     */
    readonly deploymentId: string;
}
export declare class DataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector extends cdktf.ComplexComputedList {
    get realms(): string[];
}
export declare class DataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverrides extends cdktf.ComplexComputedList {
    get configVersion(): string;
    get realmsSelector(): any;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/game_services_game_server_deployment_rollout.html google_game_services_game_server_deployment_rollout}.
 */
export declare class DataGoogleGameServicesGameServerDeploymentRollout extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/game_services_game_server_deployment_rollout.html google_game_services_game_server_deployment_rollout} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleGameServicesGameServerDeploymentRolloutConfig);
    get defaultGameServerConfig(): string;
    private _deploymentId?;
    get deploymentId(): string;
    set deploymentId(value: string);
    get deploymentIdInput(): string | undefined;
    gameServerConfigOverrides(index: string): DataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverrides;
    get id(): string;
    get name(): string;
    get project(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
