import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleFolderConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/folder.html#folder DataGoogleFolder#folder}.
     */
    readonly folder: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/folder.html#lookup_organization DataGoogleFolder#lookup_organization}.
     */
    readonly lookupOrganization?: boolean | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/folder.html google_folder}.
 */
export declare class DataGoogleFolder extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/folder.html google_folder} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleFolderConfig);
    get createTime(): string;
    get displayName(): string;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    get folderInput(): string | undefined;
    get folderId(): string;
    get id(): string;
    get lifecycleState(): string;
    private _lookupOrganization?;
    get lookupOrganization(): boolean | cdktf.IResolvable | undefined;
    set lookupOrganization(value: boolean | cdktf.IResolvable | undefined);
    resetLookupOrganization(): void;
    get lookupOrganizationInput(): boolean | cdktf.IResolvable | undefined;
    get name(): string;
    get organization(): string;
    get parent(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
