import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleFolderOrganizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Constraint the Policy is configuring, for example, serviceuser.services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/folder_organization_policy.html#constraint DataGoogleFolderOrganizationPolicy#constraint}
     */
    readonly constraint: string;
    /**
     * The resource name of the folder to set the policy for. Its format is folders/{folder_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/folder_organization_policy.html#folder DataGoogleFolderOrganizationPolicy#folder}
     */
    readonly folder: string;
}
export declare class DataGoogleFolderOrganizationPolicyBooleanPolicy extends cdktf.ComplexComputedList {
    get enforced(): any;
}
export declare class DataGoogleFolderOrganizationPolicyListPolicyAllow extends cdktf.ComplexComputedList {
    get all(): any;
    get values(): string[];
}
export declare class DataGoogleFolderOrganizationPolicyListPolicyDeny extends cdktf.ComplexComputedList {
    get all(): any;
    get values(): string[];
}
export declare class DataGoogleFolderOrganizationPolicyListPolicy extends cdktf.ComplexComputedList {
    get allow(): any;
    get deny(): any;
    get inheritFromParent(): any;
    get suggestedValue(): string;
}
export declare class DataGoogleFolderOrganizationPolicyRestorePolicy extends cdktf.ComplexComputedList {
    get default(): any;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/folder_organization_policy.html google_folder_organization_policy}.
 */
export declare class DataGoogleFolderOrganizationPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/folder_organization_policy.html google_folder_organization_policy} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleFolderOrganizationPolicyConfig);
    booleanPolicy(index: string): DataGoogleFolderOrganizationPolicyBooleanPolicy;
    private _constraint?;
    get constraint(): string;
    set constraint(value: string);
    get constraintInput(): string | undefined;
    get etag(): string;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    get folderInput(): string | undefined;
    get id(): string;
    listPolicy(index: string): DataGoogleFolderOrganizationPolicyListPolicy;
    restorePolicy(index: string): DataGoogleFolderOrganizationPolicyRestorePolicy;
    get updateTime(): string;
    get version(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
