import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleContainerRegistryImageConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_registry_image.html#digest DataGoogleContainerRegistryImage#digest}.
     */
    readonly digest?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_registry_image.html#name DataGoogleContainerRegistryImage#name}.
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_registry_image.html#project DataGoogleContainerRegistryImage#project}.
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_registry_image.html#region DataGoogleContainerRegistryImage#region}.
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_registry_image.html#tag DataGoogleContainerRegistryImage#tag}.
     */
    readonly tag?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/container_registry_image.html google_container_registry_image}.
 */
export declare class DataGoogleContainerRegistryImage extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/container_registry_image.html google_container_registry_image} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleContainerRegistryImageConfig);
    private _digest?;
    get digest(): string | undefined;
    set digest(value: string | undefined);
    resetDigest(): void;
    get digestInput(): string | undefined;
    get id(): string;
    get imageUrl(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _tag?;
    get tag(): string | undefined;
    set tag(value: string | undefined);
    resetTag(): void;
    get tagInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
