import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleContainerEngineVersionsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_engine_versions.html#location DataGoogleContainerEngineVersions#location}.
     */
    readonly location?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_engine_versions.html#project DataGoogleContainerEngineVersions#project}.
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_engine_versions.html#version_prefix DataGoogleContainerEngineVersions#version_prefix}.
     */
    readonly versionPrefix?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/container_engine_versions.html google_container_engine_versions}.
 */
export declare class DataGoogleContainerEngineVersions extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/container_engine_versions.html google_container_engine_versions} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: DataGoogleContainerEngineVersionsConfig);
    get defaultClusterVersion(): string;
    get id(): string;
    get latestMasterVersion(): string;
    get latestNodeVersion(): string;
    private _location?;
    get location(): string | undefined;
    set location(value: string | undefined);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    releaseChannelDefaultVersion(key: string): string;
    get validMasterVersions(): string[];
    get validNodeVersions(): string[];
    private _versionPrefix?;
    get versionPrefix(): string | undefined;
    set versionPrefix(value: string | undefined);
    resetVersionPrefix(): void;
    get versionPrefixInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
