import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleContainerClusterConfig extends cdktf.TerraformMetaArguments {
    /**
     * The location (region or zone) in which the cluster master will be created, as well as the default node location.
     *
     * If you specify a zone (such as us-central1-a), the cluster will be a zonal cluster with a single cluster master. If you specify a region (such as us-west1), the cluster will be a regional cluster with multiple masters spread across zones in the region, and with default node locations in those zones as well.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_cluster.html#location DataGoogleContainerCluster#location}
     */
    readonly location?: string;
    /**
     * The name of the cluster, unique within the project and location.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_cluster.html#name DataGoogleContainerCluster#name}
     */
    readonly name: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_cluster.html#project DataGoogleContainerCluster#project}
     */
    readonly project?: string;
}
export declare class DataGoogleContainerClusterAddonsConfigCloudrunConfig extends cdktf.ComplexComputedList {
    get disabled(): any;
    get loadBalancerType(): string;
}
export declare class DataGoogleContainerClusterAddonsConfigHorizontalPodAutoscaling extends cdktf.ComplexComputedList {
    get disabled(): any;
}
export declare class DataGoogleContainerClusterAddonsConfigHttpLoadBalancing extends cdktf.ComplexComputedList {
    get disabled(): any;
}
export declare class DataGoogleContainerClusterAddonsConfigNetworkPolicyConfig extends cdktf.ComplexComputedList {
    get disabled(): any;
}
export declare class DataGoogleContainerClusterAddonsConfig extends cdktf.ComplexComputedList {
    get cloudrunConfig(): any;
    get horizontalPodAutoscaling(): any;
    get httpLoadBalancing(): any;
    get networkPolicyConfig(): any;
}
export declare class DataGoogleContainerClusterAuthenticatorGroupsConfig extends cdktf.ComplexComputedList {
    get securityGroup(): string;
}
export declare class DataGoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults extends cdktf.ComplexComputedList {
    get oauthScopes(): string[];
    get serviceAccount(): string;
}
export declare class DataGoogleContainerClusterClusterAutoscalingResourceLimits extends cdktf.ComplexComputedList {
    get maximum(): number;
    get minimum(): number;
    get resourceType(): string;
}
export declare class DataGoogleContainerClusterClusterAutoscaling extends cdktf.ComplexComputedList {
    get autoProvisioningDefaults(): any;
    get enabled(): any;
    get resourceLimits(): any;
}
export declare class DataGoogleContainerClusterDatabaseEncryption extends cdktf.ComplexComputedList {
    get keyName(): string;
    get state(): string;
}
export declare class DataGoogleContainerClusterDefaultSnatStatus extends cdktf.ComplexComputedList {
    get disabled(): any;
}
export declare class DataGoogleContainerClusterIpAllocationPolicy extends cdktf.ComplexComputedList {
    get clusterIpv4CidrBlock(): string;
    get clusterSecondaryRangeName(): string;
    get servicesIpv4CidrBlock(): string;
    get servicesSecondaryRangeName(): string;
}
export declare class DataGoogleContainerClusterLoggingConfig extends cdktf.ComplexComputedList {
    get enableComponents(): string[];
}
export declare class DataGoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow extends cdktf.ComplexComputedList {
    get duration(): string;
    get startTime(): string;
}
export declare class DataGoogleContainerClusterMaintenancePolicyMaintenanceExclusion extends cdktf.ComplexComputedList {
    get endTime(): string;
    get exclusionName(): string;
    get startTime(): string;
}
export declare class DataGoogleContainerClusterMaintenancePolicyRecurringWindow extends cdktf.ComplexComputedList {
    get endTime(): string;
    get recurrence(): string;
    get startTime(): string;
}
export declare class DataGoogleContainerClusterMaintenancePolicy extends cdktf.ComplexComputedList {
    get dailyMaintenanceWindow(): any;
    get maintenanceExclusion(): any;
    get recurringWindow(): any;
}
export declare class DataGoogleContainerClusterMasterAuthClientCertificateConfig extends cdktf.ComplexComputedList {
    get issueClientCertificate(): any;
}
export declare class DataGoogleContainerClusterMasterAuth extends cdktf.ComplexComputedList {
    get clientCertificate(): string;
    get clientCertificateConfig(): any;
    get clientKey(): string;
    get clusterCaCertificate(): string;
    get password(): string;
    get username(): string;
}
export declare class DataGoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks extends cdktf.ComplexComputedList {
    get cidrBlock(): string;
    get displayName(): string;
}
export declare class DataGoogleContainerClusterMasterAuthorizedNetworksConfig extends cdktf.ComplexComputedList {
    get cidrBlocks(): any;
}
export declare class DataGoogleContainerClusterMonitoringConfig extends cdktf.ComplexComputedList {
    get enableComponents(): string[];
}
export declare class DataGoogleContainerClusterNetworkPolicy extends cdktf.ComplexComputedList {
    get enabled(): any;
    get provider(): string;
}
export declare class DataGoogleContainerClusterNodeConfigGuestAccelerator extends cdktf.ComplexComputedList {
    get count(): number;
    get gpuPartitionSize(): string;
    get type(): string;
}
export declare class DataGoogleContainerClusterNodeConfigShieldedInstanceConfig extends cdktf.ComplexComputedList {
    get enableIntegrityMonitoring(): any;
    get enableSecureBoot(): any;
}
export declare class DataGoogleContainerClusterNodeConfigTaint extends cdktf.ComplexComputedList {
    get effect(): string;
    get key(): string;
    get value(): string;
}
export declare class DataGoogleContainerClusterNodeConfigWorkloadMetadataConfig extends cdktf.ComplexComputedList {
    get mode(): string;
    get nodeMetadata(): string;
}
export declare class DataGoogleContainerClusterNodeConfig extends cdktf.ComplexComputedList {
    get diskSizeGb(): number;
    get diskType(): string;
    get guestAccelerator(): any;
    get imageType(): string;
    get labels(): any;
    get localSsdCount(): number;
    get machineType(): string;
    get metadata(): any;
    get minCpuPlatform(): string;
    get oauthScopes(): string[];
    get preemptible(): any;
    get serviceAccount(): string;
    get shieldedInstanceConfig(): any;
    get tags(): string[];
    get taint(): any;
    get workloadMetadataConfig(): any;
}
export declare class DataGoogleContainerClusterNodePoolAutoscaling extends cdktf.ComplexComputedList {
    get maxNodeCount(): number;
    get minNodeCount(): number;
}
export declare class DataGoogleContainerClusterNodePoolManagement extends cdktf.ComplexComputedList {
    get autoRepair(): any;
    get autoUpgrade(): any;
}
export declare class DataGoogleContainerClusterNodePoolNodeConfigGuestAccelerator extends cdktf.ComplexComputedList {
    get count(): number;
    get gpuPartitionSize(): string;
    get type(): string;
}
export declare class DataGoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig extends cdktf.ComplexComputedList {
    get enableIntegrityMonitoring(): any;
    get enableSecureBoot(): any;
}
export declare class DataGoogleContainerClusterNodePoolNodeConfigTaint extends cdktf.ComplexComputedList {
    get effect(): string;
    get key(): string;
    get value(): string;
}
export declare class DataGoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig extends cdktf.ComplexComputedList {
    get mode(): string;
    get nodeMetadata(): string;
}
export declare class DataGoogleContainerClusterNodePoolNodeConfig extends cdktf.ComplexComputedList {
    get diskSizeGb(): number;
    get diskType(): string;
    get guestAccelerator(): any;
    get imageType(): string;
    get labels(): any;
    get localSsdCount(): number;
    get machineType(): string;
    get metadata(): any;
    get minCpuPlatform(): string;
    get oauthScopes(): string[];
    get preemptible(): any;
    get serviceAccount(): string;
    get shieldedInstanceConfig(): any;
    get tags(): string[];
    get taint(): any;
    get workloadMetadataConfig(): any;
}
export declare class DataGoogleContainerClusterNodePoolUpgradeSettings extends cdktf.ComplexComputedList {
    get maxSurge(): number;
    get maxUnavailable(): number;
}
export declare class DataGoogleContainerClusterNodePool extends cdktf.ComplexComputedList {
    get autoscaling(): any;
    get initialNodeCount(): number;
    get instanceGroupUrls(): string[];
    get management(): any;
    get maxPodsPerNode(): number;
    get name(): string;
    get namePrefix(): string;
    get nodeConfig(): any;
    get nodeCount(): number;
    get nodeLocations(): string[];
    get upgradeSettings(): any;
    get version(): string;
}
export declare class DataGoogleContainerClusterPodSecurityPolicyConfig extends cdktf.ComplexComputedList {
    get enabled(): any;
}
export declare class DataGoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig extends cdktf.ComplexComputedList {
    get enabled(): any;
}
export declare class DataGoogleContainerClusterPrivateClusterConfig extends cdktf.ComplexComputedList {
    get enablePrivateEndpoint(): any;
    get enablePrivateNodes(): any;
    get masterGlobalAccessConfig(): any;
    get masterIpv4CidrBlock(): string;
    get peeringName(): string;
    get privateEndpoint(): string;
    get publicEndpoint(): string;
}
export declare class DataGoogleContainerClusterReleaseChannel extends cdktf.ComplexComputedList {
    get channel(): string;
}
export declare class DataGoogleContainerClusterResourceUsageExportConfigBigqueryDestination extends cdktf.ComplexComputedList {
    get datasetId(): string;
}
export declare class DataGoogleContainerClusterResourceUsageExportConfig extends cdktf.ComplexComputedList {
    get bigqueryDestination(): any;
    get enableNetworkEgressMetering(): any;
    get enableResourceConsumptionMetering(): any;
}
export declare class DataGoogleContainerClusterVerticalPodAutoscaling extends cdktf.ComplexComputedList {
    get enabled(): any;
}
export declare class DataGoogleContainerClusterWorkloadIdentityConfig extends cdktf.ComplexComputedList {
    get identityNamespace(): string;
    get workloadPool(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/container_cluster.html google_container_cluster}.
 */
export declare class DataGoogleContainerCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/container_cluster.html google_container_cluster} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleContainerClusterConfig);
    addonsConfig(index: string): DataGoogleContainerClusterAddonsConfig;
    authenticatorGroupsConfig(index: string): DataGoogleContainerClusterAuthenticatorGroupsConfig;
    clusterAutoscaling(index: string): DataGoogleContainerClusterClusterAutoscaling;
    get clusterIpv4Cidr(): string;
    databaseEncryption(index: string): DataGoogleContainerClusterDatabaseEncryption;
    get datapathProvider(): string;
    get defaultMaxPodsPerNode(): number;
    defaultSnatStatus(index: string): DataGoogleContainerClusterDefaultSnatStatus;
    get description(): string;
    get enableAutopilot(): any;
    get enableBinaryAuthorization(): any;
    get enableIntranodeVisibility(): any;
    get enableKubernetesAlpha(): any;
    get enableLegacyAbac(): any;
    get enableShieldedNodes(): any;
    get enableTpu(): any;
    get endpoint(): string;
    get id(): string;
    get initialNodeCount(): number;
    get instanceGroupUrls(): string[];
    ipAllocationPolicy(index: string): DataGoogleContainerClusterIpAllocationPolicy;
    get labelFingerprint(): string;
    private _location?;
    get location(): string | undefined;
    set location(value: string | undefined);
    resetLocation(): void;
    get locationInput(): string | undefined;
    loggingConfig(index: string): DataGoogleContainerClusterLoggingConfig;
    get loggingService(): string;
    maintenancePolicy(index: string): DataGoogleContainerClusterMaintenancePolicy;
    masterAuth(index: string): DataGoogleContainerClusterMasterAuth;
    masterAuthorizedNetworksConfig(index: string): DataGoogleContainerClusterMasterAuthorizedNetworksConfig;
    get masterVersion(): string;
    get minMasterVersion(): string;
    monitoringConfig(index: string): DataGoogleContainerClusterMonitoringConfig;
    get monitoringService(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get network(): string;
    networkPolicy(index: string): DataGoogleContainerClusterNetworkPolicy;
    get networkingMode(): string;
    nodeConfig(index: string): DataGoogleContainerClusterNodeConfig;
    get nodeLocations(): string[];
    nodePool(index: string): DataGoogleContainerClusterNodePool;
    get nodeVersion(): string;
    get operation(): string;
    podSecurityPolicyConfig(index: string): DataGoogleContainerClusterPodSecurityPolicyConfig;
    privateClusterConfig(index: string): DataGoogleContainerClusterPrivateClusterConfig;
    get privateIpv6GoogleAccess(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    releaseChannel(index: string): DataGoogleContainerClusterReleaseChannel;
    get removeDefaultNodePool(): any;
    resourceLabels(key: string): string;
    resourceUsageExportConfig(index: string): DataGoogleContainerClusterResourceUsageExportConfig;
    get selfLink(): string;
    get servicesIpv4Cidr(): string;
    get subnetwork(): string;
    get tpuIpv4CidrBlock(): string;
    verticalPodAutoscaling(index: string): DataGoogleContainerClusterVerticalPodAutoscaling;
    workloadIdentityConfig(index: string): DataGoogleContainerClusterWorkloadIdentityConfig;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
