import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeZonesConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_zones.html#project DataGoogleComputeZones#project}.
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_zones.html#region DataGoogleComputeZones#region}.
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_zones.html#status DataGoogleComputeZones#status}.
     */
    readonly status?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_zones.html google_compute_zones}.
 */
export declare class DataGoogleComputeZones extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_zones.html google_compute_zones} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeZonesConfig);
    get id(): string;
    get names(): string[];
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _status?;
    get status(): string | undefined;
    set status(value: string | undefined);
    resetStatus(): void;
    get statusInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
