import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeSubnetworkConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_subnetwork.html#name DataGoogleComputeSubnetwork#name}.
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_subnetwork.html#project DataGoogleComputeSubnetwork#project}.
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_subnetwork.html#region DataGoogleComputeSubnetwork#region}.
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_subnetwork.html#self_link DataGoogleComputeSubnetwork#self_link}.
     */
    readonly selfLink?: string;
}
export declare class DataGoogleComputeSubnetworkSecondaryIpRange extends cdktf.ComplexComputedList {
    get ipCidrRange(): string;
    get rangeName(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_subnetwork.html google_compute_subnetwork}.
 */
export declare class DataGoogleComputeSubnetwork extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_subnetwork.html google_compute_subnetwork} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeSubnetworkConfig);
    get description(): string;
    get gatewayAddress(): string;
    get id(): string;
    get ipCidrRange(): string;
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    resetName(): void;
    get nameInput(): string | undefined;
    get network(): string;
    get privateIpGoogleAccess(): any;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    secondaryIpRange(index: string): DataGoogleComputeSubnetworkSecondaryIpRange;
    private _selfLink?;
    get selfLink(): string | undefined;
    set selfLink(value: string | undefined);
    resetSelfLink(): void;
    get selfLinkInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
