import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeResourcePolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the resource, provided by the client when initially creating the resource.
     *
     * The resource name must be 1-63 characters long, and comply
     * with RFC1035. Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])'? which means the
     * first character must be a lowercase letter, and all following characters
     * must be a dash, lowercase letter, or digit, except the last character,
     * which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_resource_policy.html#name DataGoogleComputeResourcePolicy#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_resource_policy.html#project DataGoogleComputeResourcePolicy#project}.
     */
    readonly project?: string;
    /**
     * Region where resource policy resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_resource_policy.html#region DataGoogleComputeResourcePolicy#region}
     */
    readonly region?: string;
}
export declare class DataGoogleComputeResourcePolicyGroupPlacementPolicy extends cdktf.ComplexComputedList {
    get availabilityDomainCount(): number;
    get collocation(): string;
    get vmCount(): number;
}
export declare class DataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule extends cdktf.ComplexComputedList {
    get schedule(): string;
}
export declare class DataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule extends cdktf.ComplexComputedList {
    get schedule(): string;
}
export declare class DataGoogleComputeResourcePolicyInstanceSchedulePolicy extends cdktf.ComplexComputedList {
    get expirationTime(): string;
    get startTime(): string;
    get timeZone(): string;
    get vmStartSchedule(): any;
    get vmStopSchedule(): any;
}
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy extends cdktf.ComplexComputedList {
    get maxRetentionDays(): number;
    get onSourceDiskDelete(): string;
}
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule extends cdktf.ComplexComputedList {
    get daysInCycle(): number;
    get startTime(): string;
}
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule extends cdktf.ComplexComputedList {
    get hoursInCycle(): number;
    get startTime(): string;
}
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks extends cdktf.ComplexComputedList {
    get day(): string;
    get startTime(): string;
}
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule extends cdktf.ComplexComputedList {
    get dayOfWeeks(): any;
}
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicySchedule extends cdktf.ComplexComputedList {
    get dailySchedule(): any;
    get hourlySchedule(): any;
    get weeklySchedule(): any;
}
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicySnapshotProperties extends cdktf.ComplexComputedList {
    get guestFlush(): any;
    get labels(): any;
    get storageLocations(): string[];
}
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicy extends cdktf.ComplexComputedList {
    get retentionPolicy(): any;
    get schedule(): any;
    get snapshotProperties(): any;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_resource_policy.html google_compute_resource_policy}.
 */
export declare class DataGoogleComputeResourcePolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_resource_policy.html google_compute_resource_policy} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleComputeResourcePolicyConfig);
    get description(): string;
    groupPlacementPolicy(index: string): DataGoogleComputeResourcePolicyGroupPlacementPolicy;
    get id(): string;
    instanceSchedulePolicy(index: string): DataGoogleComputeResourcePolicyInstanceSchedulePolicy;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    snapshotSchedulePolicy(index: string): DataGoogleComputeResourcePolicySnapshotSchedulePolicy;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
