import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeRegionsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_regions.html#project DataGoogleComputeRegions#project}.
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_regions.html#status DataGoogleComputeRegions#status}.
     */
    readonly status?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_regions.html google_compute_regions}.
 */
export declare class DataGoogleComputeRegions extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_regions.html google_compute_regions} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeRegionsConfig);
    get id(): string;
    get names(): string[];
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _status?;
    get status(): string | undefined;
    set status(value: string | undefined);
    resetStatus(): void;
    get statusInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
