import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeRegionInstanceGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_region_instance_group.html#name DataGoogleComputeRegionInstanceGroup#name}.
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_region_instance_group.html#project DataGoogleComputeRegionInstanceGroup#project}.
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_region_instance_group.html#region DataGoogleComputeRegionInstanceGroup#region}.
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_region_instance_group.html#self_link DataGoogleComputeRegionInstanceGroup#self_link}.
     */
    readonly selfLink?: string;
}
export declare class DataGoogleComputeRegionInstanceGroupInstancesNamedPorts extends cdktf.ComplexComputedList {
    get name(): string;
    get port(): number;
}
export declare class DataGoogleComputeRegionInstanceGroupInstances extends cdktf.ComplexComputedList {
    get instance(): string;
    get namedPorts(): any;
    get status(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_region_instance_group.html google_compute_region_instance_group}.
 */
export declare class DataGoogleComputeRegionInstanceGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_region_instance_group.html google_compute_region_instance_group} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeRegionInstanceGroupConfig);
    get id(): string;
    instances(index: string): DataGoogleComputeRegionInstanceGroupInstances;
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    resetName(): void;
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _selfLink?;
    get selfLink(): string | undefined;
    set selfLink(value: string | undefined);
    resetSelfLink(): void;
    get selfLinkInput(): string | undefined;
    get size(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
