import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_network.html#name DataGoogleComputeNetwork#name}.
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_network.html#project DataGoogleComputeNetwork#project}.
     */
    readonly project?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_network.html google_compute_network}.
 */
export declare class DataGoogleComputeNetwork extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_network.html google_compute_network} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleComputeNetworkConfig);
    get description(): string;
    get gatewayIpv4(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    get subnetworksSelfLinks(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
