import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeNetworkEndpointGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the resource;
     *
     * provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_network_endpoint_group.html#name DataGoogleComputeNetworkEndpointGroup#name}
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_network_endpoint_group.html#project DataGoogleComputeNetworkEndpointGroup#project}.
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_network_endpoint_group.html#self_link DataGoogleComputeNetworkEndpointGroup#self_link}.
     */
    readonly selfLink?: string;
    /**
     * Zone where the network endpoint group is located.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_network_endpoint_group.html#zone DataGoogleComputeNetworkEndpointGroup#zone}
     */
    readonly zone?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_network_endpoint_group.html google_compute_network_endpoint_group}.
 */
export declare class DataGoogleComputeNetworkEndpointGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_network_endpoint_group.html google_compute_network_endpoint_group} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeNetworkEndpointGroupConfig);
    get defaultPort(): number;
    get description(): string;
    get id(): string;
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    resetName(): void;
    get nameInput(): string | undefined;
    get network(): string;
    get networkEndpointType(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _selfLink?;
    get selfLink(): string | undefined;
    set selfLink(value: string | undefined);
    resetSelfLink(): void;
    get selfLinkInput(): string | undefined;
    get size(): number;
    get subnetwork(): string;
    private _zone?;
    get zone(): string | undefined;
    set zone(value: string | undefined);
    resetZone(): void;
    get zoneInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
