import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the instance. One of name or self_link must be provided.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance.html#name DataGoogleComputeInstance#name}
     */
    readonly name?: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If self_link is provided, this value is ignored. If neither self_link nor project are provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance.html#project DataGoogleComputeInstance#project}
     */
    readonly project?: string;
    /**
     * The URI of the created resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance.html#self_link DataGoogleComputeInstance#self_link}
     */
    readonly selfLink?: string;
    /**
     * The zone of the instance.
     *
     * If self_link is provided, this value is ignored. If neither self_link nor zone are provided, the provider zone is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance.html#zone DataGoogleComputeInstance#zone}
     */
    readonly zone?: string;
}
export declare class DataGoogleComputeInstanceAdvancedMachineFeatures extends cdktf.ComplexComputedList {
    get enableNestedVirtualization(): any;
    get threadsPerCore(): number;
}
export declare class DataGoogleComputeInstanceAttachedDisk extends cdktf.ComplexComputedList {
    get deviceName(): string;
    get diskEncryptionKeyRaw(): string;
    get diskEncryptionKeySha256(): string;
    get kmsKeySelfLink(): string;
    get mode(): string;
    get source(): string;
}
export declare class DataGoogleComputeInstanceBootDiskInitializeParams extends cdktf.ComplexComputedList {
    get image(): string;
    get labels(): any;
    get size(): number;
    get type(): string;
}
export declare class DataGoogleComputeInstanceBootDisk extends cdktf.ComplexComputedList {
    get autoDelete(): any;
    get deviceName(): string;
    get diskEncryptionKeyRaw(): string;
    get diskEncryptionKeySha256(): string;
    get initializeParams(): any;
    get kmsKeySelfLink(): string;
    get mode(): string;
    get source(): string;
}
export declare class DataGoogleComputeInstanceConfidentialInstanceConfig extends cdktf.ComplexComputedList {
    get enableConfidentialCompute(): any;
}
export declare class DataGoogleComputeInstanceGuestAccelerator extends cdktf.ComplexComputedList {
    get count(): number;
    get type(): string;
}
export declare class DataGoogleComputeInstanceNetworkInterfaceAccessConfig extends cdktf.ComplexComputedList {
    get natIp(): string;
    get networkTier(): string;
    get publicPtrDomainName(): string;
}
export declare class DataGoogleComputeInstanceNetworkInterfaceAliasIpRange extends cdktf.ComplexComputedList {
    get ipCidrRange(): string;
    get subnetworkRangeName(): string;
}
export declare class DataGoogleComputeInstanceNetworkInterfaceIpv6AccessConfig extends cdktf.ComplexComputedList {
    get externalIpv6(): string;
    get externalIpv6PrefixLength(): string;
    get networkTier(): string;
    get publicPtrDomainName(): string;
}
export declare class DataGoogleComputeInstanceNetworkInterface extends cdktf.ComplexComputedList {
    get accessConfig(): any;
    get aliasIpRange(): any;
    get ipv6AccessConfig(): any;
    get ipv6AccessType(): string;
    get name(): string;
    get network(): string;
    get networkIp(): string;
    get nicType(): string;
    get stackType(): string;
    get subnetwork(): string;
    get subnetworkProject(): string;
}
export declare class DataGoogleComputeInstanceReservationAffinitySpecificReservation extends cdktf.ComplexComputedList {
    get key(): string;
    get values(): string[];
}
export declare class DataGoogleComputeInstanceReservationAffinity extends cdktf.ComplexComputedList {
    get specificReservation(): any;
    get type(): string;
}
export declare class DataGoogleComputeInstanceSchedulingNodeAffinities extends cdktf.ComplexComputedList {
    get key(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataGoogleComputeInstanceScheduling extends cdktf.ComplexComputedList {
    get automaticRestart(): any;
    get minNodeCpus(): number;
    get nodeAffinities(): any;
    get onHostMaintenance(): string;
    get preemptible(): any;
}
export declare class DataGoogleComputeInstanceScratchDisk extends cdktf.ComplexComputedList {
    get interface(): string;
}
export declare class DataGoogleComputeInstanceServiceAccount extends cdktf.ComplexComputedList {
    get email(): string;
    get scopes(): string[];
}
export declare class DataGoogleComputeInstanceShieldedInstanceConfig extends cdktf.ComplexComputedList {
    get enableIntegrityMonitoring(): any;
    get enableSecureBoot(): any;
    get enableVtpm(): any;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_instance.html google_compute_instance}.
 */
export declare class DataGoogleComputeInstance extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_instance.html google_compute_instance} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeInstanceConfig);
    advancedMachineFeatures(index: string): DataGoogleComputeInstanceAdvancedMachineFeatures;
    get allowStoppingForUpdate(): any;
    attachedDisk(index: string): DataGoogleComputeInstanceAttachedDisk;
    bootDisk(index: string): DataGoogleComputeInstanceBootDisk;
    get canIpForward(): any;
    confidentialInstanceConfig(index: string): DataGoogleComputeInstanceConfidentialInstanceConfig;
    get cpuPlatform(): string;
    get currentStatus(): string;
    get deletionProtection(): any;
    get description(): string;
    get desiredStatus(): string;
    get enableDisplay(): any;
    guestAccelerator(index: string): DataGoogleComputeInstanceGuestAccelerator;
    get hostname(): string;
    get id(): string;
    get instanceId(): string;
    get labelFingerprint(): string;
    labels(key: string): string;
    get machineType(): string;
    metadata(key: string): string;
    get metadataFingerprint(): string;
    get metadataStartupScript(): string;
    get minCpuPlatform(): string;
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    resetName(): void;
    get nameInput(): string | undefined;
    networkInterface(index: string): DataGoogleComputeInstanceNetworkInterface;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    reservationAffinity(index: string): DataGoogleComputeInstanceReservationAffinity;
    get resourcePolicies(): string[];
    scheduling(index: string): DataGoogleComputeInstanceScheduling;
    scratchDisk(index: string): DataGoogleComputeInstanceScratchDisk;
    private _selfLink?;
    get selfLink(): string | undefined;
    set selfLink(value: string | undefined);
    resetSelfLink(): void;
    get selfLinkInput(): string | undefined;
    serviceAccount(index: string): DataGoogleComputeInstanceServiceAccount;
    shieldedInstanceConfig(index: string): DataGoogleComputeInstanceShieldedInstanceConfig;
    get tags(): string[];
    get tagsFingerprint(): string;
    private _zone?;
    get zone(): string | undefined;
    set zone(value: string | undefined);
    resetZone(): void;
    get zoneInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
