import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeInstanceTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance_template.html#filter DataGoogleComputeInstanceTemplate#filter}.
     */
    readonly filter?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance_template.html#most_recent DataGoogleComputeInstanceTemplate#most_recent}.
     */
    readonly mostRecent?: boolean | cdktf.IResolvable;
    /**
     * The name of the instance template. If you leave this blank, Terraform will auto-generate a unique name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance_template.html#name DataGoogleComputeInstanceTemplate#name}
     */
    readonly name?: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance_template.html#project DataGoogleComputeInstanceTemplate#project}
     */
    readonly project: string;
}
export declare class DataGoogleComputeInstanceTemplateAdvancedMachineFeatures extends cdktf.ComplexComputedList {
    get enableNestedVirtualization(): any;
    get threadsPerCore(): number;
}
export declare class DataGoogleComputeInstanceTemplateConfidentialInstanceConfig extends cdktf.ComplexComputedList {
    get enableConfidentialCompute(): any;
}
export declare class DataGoogleComputeInstanceTemplateDiskDiskEncryptionKey extends cdktf.ComplexComputedList {
    get kmsKeySelfLink(): string;
}
export declare class DataGoogleComputeInstanceTemplateDisk extends cdktf.ComplexComputedList {
    get autoDelete(): any;
    get boot(): any;
    get deviceName(): string;
    get diskEncryptionKey(): any;
    get diskName(): string;
    get diskSizeGb(): number;
    get diskType(): string;
    get interface(): string;
    get labels(): any;
    get mode(): string;
    get resourcePolicies(): string[];
    get source(): string;
    get sourceImage(): string;
    get type(): string;
}
export declare class DataGoogleComputeInstanceTemplateGuestAccelerator extends cdktf.ComplexComputedList {
    get count(): number;
    get type(): string;
}
export declare class DataGoogleComputeInstanceTemplateNetworkInterfaceAccessConfig extends cdktf.ComplexComputedList {
    get natIp(): string;
    get networkTier(): string;
    get publicPtrDomainName(): string;
}
export declare class DataGoogleComputeInstanceTemplateNetworkInterfaceAliasIpRange extends cdktf.ComplexComputedList {
    get ipCidrRange(): string;
    get subnetworkRangeName(): string;
}
export declare class DataGoogleComputeInstanceTemplateNetworkInterfaceIpv6AccessConfig extends cdktf.ComplexComputedList {
    get externalIpv6(): string;
    get externalIpv6PrefixLength(): string;
    get networkTier(): string;
    get publicPtrDomainName(): string;
}
export declare class DataGoogleComputeInstanceTemplateNetworkInterface extends cdktf.ComplexComputedList {
    get accessConfig(): any;
    get aliasIpRange(): any;
    get ipv6AccessConfig(): any;
    get ipv6AccessType(): string;
    get name(): string;
    get network(): string;
    get networkIp(): string;
    get nicType(): string;
    get stackType(): string;
    get subnetwork(): string;
    get subnetworkProject(): string;
}
export declare class DataGoogleComputeInstanceTemplateReservationAffinitySpecificReservation extends cdktf.ComplexComputedList {
    get key(): string;
    get values(): string[];
}
export declare class DataGoogleComputeInstanceTemplateReservationAffinity extends cdktf.ComplexComputedList {
    get specificReservation(): any;
    get type(): string;
}
export declare class DataGoogleComputeInstanceTemplateSchedulingNodeAffinities extends cdktf.ComplexComputedList {
    get key(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataGoogleComputeInstanceTemplateScheduling extends cdktf.ComplexComputedList {
    get automaticRestart(): any;
    get minNodeCpus(): number;
    get nodeAffinities(): any;
    get onHostMaintenance(): string;
    get preemptible(): any;
}
export declare class DataGoogleComputeInstanceTemplateServiceAccount extends cdktf.ComplexComputedList {
    get email(): string;
    get scopes(): string[];
}
export declare class DataGoogleComputeInstanceTemplateShieldedInstanceConfig extends cdktf.ComplexComputedList {
    get enableIntegrityMonitoring(): any;
    get enableSecureBoot(): any;
    get enableVtpm(): any;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_instance_template.html google_compute_instance_template}.
 */
export declare class DataGoogleComputeInstanceTemplate extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_instance_template.html google_compute_instance_template} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleComputeInstanceTemplateConfig);
    advancedMachineFeatures(index: string): DataGoogleComputeInstanceTemplateAdvancedMachineFeatures;
    get canIpForward(): any;
    confidentialInstanceConfig(index: string): DataGoogleComputeInstanceTemplateConfidentialInstanceConfig;
    get description(): string;
    disk(index: string): DataGoogleComputeInstanceTemplateDisk;
    get enableDisplay(): any;
    private _filter?;
    get filter(): string | undefined;
    set filter(value: string | undefined);
    resetFilter(): void;
    get filterInput(): string | undefined;
    guestAccelerator(index: string): DataGoogleComputeInstanceTemplateGuestAccelerator;
    get id(): string;
    get instanceDescription(): string;
    labels(key: string): string;
    get machineType(): string;
    metadata(key: string): string;
    get metadataFingerprint(): string;
    get metadataStartupScript(): string;
    get minCpuPlatform(): string;
    private _mostRecent?;
    get mostRecent(): boolean | cdktf.IResolvable | undefined;
    set mostRecent(value: boolean | cdktf.IResolvable | undefined);
    resetMostRecent(): void;
    get mostRecentInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    resetName(): void;
    get nameInput(): string | undefined;
    get namePrefix(): string;
    networkInterface(index: string): DataGoogleComputeInstanceTemplateNetworkInterface;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    get region(): string;
    reservationAffinity(index: string): DataGoogleComputeInstanceTemplateReservationAffinity;
    scheduling(index: string): DataGoogleComputeInstanceTemplateScheduling;
    get selfLink(): string;
    serviceAccount(index: string): DataGoogleComputeInstanceTemplateServiceAccount;
    shieldedInstanceConfig(index: string): DataGoogleComputeInstanceTemplateShieldedInstanceConfig;
    get tags(): string[];
    get tagsFingerprint(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
