import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeInstanceGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance_group.html#name DataGoogleComputeInstanceGroup#name}.
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance_group.html#project DataGoogleComputeInstanceGroup#project}.
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance_group.html#self_link DataGoogleComputeInstanceGroup#self_link}.
     */
    readonly selfLink?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance_group.html#zone DataGoogleComputeInstanceGroup#zone}.
     */
    readonly zone?: string;
}
export declare class DataGoogleComputeInstanceGroupNamedPort extends cdktf.ComplexComputedList {
    get name(): string;
    get port(): number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_instance_group.html google_compute_instance_group}.
 */
export declare class DataGoogleComputeInstanceGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_instance_group.html google_compute_instance_group} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeInstanceGroupConfig);
    get description(): string;
    get id(): string;
    get instances(): string[];
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    resetName(): void;
    get nameInput(): string | undefined;
    namedPort(index: string): DataGoogleComputeInstanceGroupNamedPort;
    get network(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _selfLink?;
    get selfLink(): string | undefined;
    set selfLink(value: string | undefined);
    resetSelfLink(): void;
    get selfLinkInput(): string | undefined;
    get size(): number;
    private _zone?;
    get zone(): string | undefined;
    set zone(value: string | undefined);
    resetZone(): void;
    get zoneInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
