import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeImageConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_image.html#family DataGoogleComputeImage#family}.
     */
    readonly family?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_image.html#filter DataGoogleComputeImage#filter}.
     */
    readonly filter?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_image.html#name DataGoogleComputeImage#name}.
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_image.html#project DataGoogleComputeImage#project}.
     */
    readonly project?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_image.html google_compute_image}.
 */
export declare class DataGoogleComputeImage extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_image.html google_compute_image} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeImageConfig);
    get archiveSizeBytes(): number;
    get creationTimestamp(): string;
    get description(): string;
    get diskSizeGb(): number;
    private _family?;
    get family(): string | undefined;
    set family(value: string | undefined);
    resetFamily(): void;
    get familyInput(): string | undefined;
    private _filter?;
    get filter(): string | undefined;
    set filter(value: string | undefined);
    resetFilter(): void;
    get filterInput(): string | undefined;
    get id(): string;
    get imageEncryptionKeySha256(): string;
    get imageId(): string;
    get labelFingerprint(): string;
    labels(key: string): string;
    get licenses(): string[];
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    resetName(): void;
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    get sourceDisk(): string;
    get sourceDiskEncryptionKeySha256(): string;
    get sourceDiskId(): string;
    get sourceImageId(): string;
    get status(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
