import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeHealthCheckConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035.  Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
     * the first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the
     * last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_health_check.html#name DataGoogleComputeHealthCheck#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_health_check.html#project DataGoogleComputeHealthCheck#project}.
     */
    readonly project?: string;
}
export declare class DataGoogleComputeHealthCheckGrpcHealthCheck extends cdktf.ComplexComputedList {
    get grpcServiceName(): string;
    get port(): number;
    get portName(): string;
    get portSpecification(): string;
}
export declare class DataGoogleComputeHealthCheckHttp2HealthCheck extends cdktf.ComplexComputedList {
    get host(): string;
    get port(): number;
    get portName(): string;
    get portSpecification(): string;
    get proxyHeader(): string;
    get requestPath(): string;
    get response(): string;
}
export declare class DataGoogleComputeHealthCheckHttpHealthCheck extends cdktf.ComplexComputedList {
    get host(): string;
    get port(): number;
    get portName(): string;
    get portSpecification(): string;
    get proxyHeader(): string;
    get requestPath(): string;
    get response(): string;
}
export declare class DataGoogleComputeHealthCheckHttpsHealthCheck extends cdktf.ComplexComputedList {
    get host(): string;
    get port(): number;
    get portName(): string;
    get portSpecification(): string;
    get proxyHeader(): string;
    get requestPath(): string;
    get response(): string;
}
export declare class DataGoogleComputeHealthCheckLogConfig extends cdktf.ComplexComputedList {
    get enable(): any;
}
export declare class DataGoogleComputeHealthCheckSslHealthCheck extends cdktf.ComplexComputedList {
    get port(): number;
    get portName(): string;
    get portSpecification(): string;
    get proxyHeader(): string;
    get request(): string;
    get response(): string;
}
export declare class DataGoogleComputeHealthCheckTcpHealthCheck extends cdktf.ComplexComputedList {
    get port(): number;
    get portName(): string;
    get portSpecification(): string;
    get proxyHeader(): string;
    get request(): string;
    get response(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_health_check.html google_compute_health_check}.
 */
export declare class DataGoogleComputeHealthCheck extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_health_check.html google_compute_health_check} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleComputeHealthCheckConfig);
    get checkIntervalSec(): number;
    get creationTimestamp(): string;
    get description(): string;
    grpcHealthCheck(index: string): DataGoogleComputeHealthCheckGrpcHealthCheck;
    get healthyThreshold(): number;
    http2HealthCheck(index: string): DataGoogleComputeHealthCheckHttp2HealthCheck;
    httpHealthCheck(index: string): DataGoogleComputeHealthCheckHttpHealthCheck;
    httpsHealthCheck(index: string): DataGoogleComputeHealthCheckHttpsHealthCheck;
    get id(): string;
    logConfig(index: string): DataGoogleComputeHealthCheckLogConfig;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    sslHealthCheck(index: string): DataGoogleComputeHealthCheckSslHealthCheck;
    tcpHealthCheck(index: string): DataGoogleComputeHealthCheckTcpHealthCheck;
    get timeoutSec(): number;
    get type(): string;
    get unhealthyThreshold(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
