import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeHaVpnGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035.  Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
     * the first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_ha_vpn_gateway.html#name DataGoogleComputeHaVpnGateway#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_ha_vpn_gateway.html#project DataGoogleComputeHaVpnGateway#project}.
     */
    readonly project?: string;
    /**
     * The region this gateway should sit in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_ha_vpn_gateway.html#region DataGoogleComputeHaVpnGateway#region}
     */
    readonly region?: string;
}
export declare class DataGoogleComputeHaVpnGatewayVpnInterfaces extends cdktf.ComplexComputedList {
    get id(): number;
    get interconnectAttachment(): string;
    get ipAddress(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_ha_vpn_gateway.html google_compute_ha_vpn_gateway}.
 */
export declare class DataGoogleComputeHaVpnGateway extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_ha_vpn_gateway.html google_compute_ha_vpn_gateway} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleComputeHaVpnGatewayConfig);
    get description(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get network(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    vpnInterfaces(index: string): DataGoogleComputeHaVpnGatewayVpnInterfaces;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
