import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeGlobalAddressConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_global_address.html#name DataGoogleComputeGlobalAddress#name}.
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_global_address.html#project DataGoogleComputeGlobalAddress#project}.
     */
    readonly project?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_global_address.html google_compute_global_address}.
 */
export declare class DataGoogleComputeGlobalAddress extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_global_address.html google_compute_global_address} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleComputeGlobalAddressConfig);
    get address(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    get status(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
