import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeForwardingRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the resource;
     *
     * provided by the client when the resource is created. The name must be 1-63 characters long, and comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_forwarding_rule.html#name DataGoogleComputeForwardingRule#name}
     */
    readonly name: string;
    /**
     * The project this resource belongs in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_forwarding_rule.html#project DataGoogleComputeForwardingRule#project}
     */
    readonly project?: string;
    /**
     * The location of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_forwarding_rule.html#region DataGoogleComputeForwardingRule#region}
     */
    readonly region?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_forwarding_rule.html google_compute_forwarding_rule}.
 */
export declare class DataGoogleComputeForwardingRule extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_forwarding_rule.html google_compute_forwarding_rule} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleComputeForwardingRuleConfig);
    get allPorts(): any;
    get allowGlobalAccess(): any;
    get backendService(): string;
    get creationTimestamp(): string;
    get description(): string;
    get id(): string;
    get ipAddress(): string;
    get ipProtocol(): string;
    get isMirroringCollector(): any;
    get labelFingerprint(): string;
    labels(key: string): string;
    get loadBalancingScheme(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get network(): string;
    get networkTier(): string;
    get portRange(): string;
    get ports(): string[];
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    get serviceLabel(): string;
    get serviceName(): string;
    get subnetwork(): string;
    get target(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
