import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeDefaultServiceAccountConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_default_service_account.html#project DataGoogleComputeDefaultServiceAccount#project}.
     */
    readonly project?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_default_service_account.html google_compute_default_service_account}.
 */
export declare class DataGoogleComputeDefaultServiceAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_default_service_account.html google_compute_default_service_account} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeDefaultServiceAccountConfig);
    get displayName(): string;
    get email(): string;
    get id(): string;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get uniqueId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
