import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComposerImageVersionsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/composer_image_versions.html#project DataGoogleComposerImageVersions#project}.
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/composer_image_versions.html#region DataGoogleComposerImageVersions#region}.
     */
    readonly region?: string;
}
export declare class DataGoogleComposerImageVersionsImageVersions extends cdktf.ComplexComputedList {
    get imageVersionId(): string;
    get supportedPythonVersions(): string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/composer_image_versions.html google_composer_image_versions}.
 */
export declare class DataGoogleComposerImageVersions extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/composer_image_versions.html google_composer_image_versions} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: DataGoogleComposerImageVersionsConfig);
    get id(): string;
    imageVersions(index: string): DataGoogleComposerImageVersionsImageVersions;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
