import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComposerEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/composer_environment.html#name DataGoogleComposerEnvironment#name}
     */
    readonly name: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/composer_environment.html#project DataGoogleComposerEnvironment#project}
     */
    readonly project?: string;
    /**
     * The location or Compute Engine region for the environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/composer_environment.html#region DataGoogleComposerEnvironment#region}
     */
    readonly region?: string;
}
export declare class DataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicy extends cdktf.ComplexComputedList {
    get clusterIpv4CidrBlock(): string;
    get clusterSecondaryRangeName(): string;
    get servicesIpv4CidrBlock(): string;
    get servicesSecondaryRangeName(): string;
    get useIpAliases(): any;
}
export declare class DataGoogleComposerEnvironmentConfigNodeConfig extends cdktf.ComplexComputedList {
    get diskSizeGb(): number;
    get ipAllocationPolicy(): any;
    get machineType(): string;
    get network(): string;
    get oauthScopes(): string[];
    get serviceAccount(): string;
    get subnetwork(): string;
    get tags(): string[];
    get zone(): string;
}
export declare class DataGoogleComposerEnvironmentConfigPrivateEnvironmentConfig extends cdktf.ComplexComputedList {
    get cloudSqlIpv4CidrBlock(): string;
    get enablePrivateEndpoint(): any;
    get masterIpv4CidrBlock(): string;
    get webServerIpv4CidrBlock(): string;
}
export declare class DataGoogleComposerEnvironmentConfigSoftwareConfig extends cdktf.ComplexComputedList {
    get airflowConfigOverrides(): any;
    get envVariables(): any;
    get imageVersion(): string;
    get pypiPackages(): any;
    get pythonVersion(): string;
    get schedulerCount(): number;
}
export declare class DataGoogleComposerEnvironmentConfigA extends cdktf.ComplexComputedList {
    get airflowUri(): string;
    get dagGcsPrefix(): string;
    get gkeCluster(): string;
    get nodeConfig(): any;
    get nodeCount(): number;
    get privateEnvironmentConfig(): any;
    get softwareConfig(): any;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/composer_environment.html google_composer_environment}.
 */
export declare class DataGoogleComposerEnvironment extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/composer_environment.html google_composer_environment} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleComposerEnvironmentConfig);
    config(index: string): DataGoogleComposerEnvironmentConfigA;
    get id(): string;
    labels(key: string): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
