import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleCloudfunctionsFunctionConfig extends cdktf.TerraformMetaArguments {
    /**
     * A user-defined name of the function. Function names must be unique globally.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloudfunctions_function.html#name DataGoogleCloudfunctionsFunction#name}
     */
    readonly name: string;
    /**
     * Project of the function. If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloudfunctions_function.html#project DataGoogleCloudfunctionsFunction#project}
     */
    readonly project?: string;
    /**
     * Region of function. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloudfunctions_function.html#region DataGoogleCloudfunctionsFunction#region}
     */
    readonly region?: string;
}
export declare class DataGoogleCloudfunctionsFunctionEventTriggerFailurePolicy extends cdktf.ComplexComputedList {
    get retry(): any;
}
export declare class DataGoogleCloudfunctionsFunctionEventTrigger extends cdktf.ComplexComputedList {
    get eventType(): string;
    get failurePolicy(): any;
    get resource(): string;
}
export declare class DataGoogleCloudfunctionsFunctionSourceRepository extends cdktf.ComplexComputedList {
    get deployedUrl(): string;
    get url(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/cloudfunctions_function.html google_cloudfunctions_function}.
 */
export declare class DataGoogleCloudfunctionsFunction extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/cloudfunctions_function.html google_cloudfunctions_function} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleCloudfunctionsFunctionConfig);
    get availableMemoryMb(): number;
    buildEnvironmentVariables(key: string): string;
    get description(): string;
    get entryPoint(): string;
    environmentVariables(key: string): string;
    eventTrigger(index: string): DataGoogleCloudfunctionsFunctionEventTrigger;
    get httpsTriggerUrl(): string;
    get id(): string;
    get ingressSettings(): string;
    labels(key: string): string;
    get maxInstances(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get runtime(): string;
    get serviceAccountEmail(): string;
    get sourceArchiveBucket(): string;
    get sourceArchiveObject(): string;
    sourceRepository(index: string): DataGoogleCloudfunctionsFunctionSourceRepository;
    get timeout(): number;
    get triggerHttp(): any;
    get vpcConnector(): string;
    get vpcConnectorEgressSettings(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
