import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleCloudRunServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The location of the cloud run instance. eg us-central1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloud_run_service.html#location DataGoogleCloudRunService#location}
     */
    readonly location: string;
    /**
     * Name must be unique within a namespace, within a Cloud Run region.
     *
     * Is required when creating resources. Name is primarily intended
     * for creation idempotence and configuration definition. Cannot be updated.
     * More info: http://kubernetes.io/docs/user-guide/identifiers#names
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloud_run_service.html#name DataGoogleCloudRunService#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloud_run_service.html#project DataGoogleCloudRunService#project}.
     */
    readonly project?: string;
}
export declare class DataGoogleCloudRunServiceMetadata extends cdktf.ComplexComputedList {
    get annotations(): any;
    get generation(): number;
    get labels(): any;
    get namespace(): string;
    get resourceVersion(): string;
    get selfLink(): string;
    get uid(): string;
}
export declare class DataGoogleCloudRunServiceStatusConditions extends cdktf.ComplexComputedList {
    get message(): string;
    get reason(): string;
    get status(): string;
    get type(): string;
}
export declare class DataGoogleCloudRunServiceStatus extends cdktf.ComplexComputedList {
    get conditions(): any;
    get latestCreatedRevisionName(): string;
    get latestReadyRevisionName(): string;
    get observedGeneration(): number;
    get url(): string;
}
export declare class DataGoogleCloudRunServiceTemplateMetadata extends cdktf.ComplexComputedList {
    get annotations(): any;
    get generation(): number;
    get labels(): any;
    get name(): string;
    get namespace(): string;
    get resourceVersion(): string;
    get selfLink(): string;
    get uid(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnv extends cdktf.ComplexComputedList {
    get name(): string;
    get value(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference extends cdktf.ComplexComputedList {
    get name(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRef extends cdktf.ComplexComputedList {
    get localObjectReference(): any;
    get optional(): any;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference extends cdktf.ComplexComputedList {
    get name(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRef extends cdktf.ComplexComputedList {
    get localObjectReference(): any;
    get optional(): any;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFrom extends cdktf.ComplexComputedList {
    get configMapRef(): any;
    get prefix(): string;
    get secretRef(): any;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersPorts extends cdktf.ComplexComputedList {
    get containerPort(): number;
    get name(): string;
    get protocol(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersResources extends cdktf.ComplexComputedList {
    get limits(): any;
    get requests(): any;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainers extends cdktf.ComplexComputedList {
    get args(): string[];
    get command(): string[];
    get env(): any;
    get envFrom(): any;
    get image(): string;
    get ports(): any;
    get resources(): any;
    get workingDir(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpec extends cdktf.ComplexComputedList {
    get containerConcurrency(): number;
    get containers(): any;
    get serviceAccountName(): string;
    get servingState(): string;
    get timeoutSeconds(): number;
}
export declare class DataGoogleCloudRunServiceTemplate extends cdktf.ComplexComputedList {
    get metadata(): any;
    get spec(): any;
}
export declare class DataGoogleCloudRunServiceTraffic extends cdktf.ComplexComputedList {
    get latestRevision(): any;
    get percent(): number;
    get revisionName(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/cloud_run_service.html google_cloud_run_service}.
 */
export declare class DataGoogleCloudRunService extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/cloud_run_service.html google_cloud_run_service} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleCloudRunServiceConfig);
    get autogenerateRevisionName(): any;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    metadata(index: string): DataGoogleCloudRunServiceMetadata;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    status(index: string): DataGoogleCloudRunServiceStatus;
    template(index: string): DataGoogleCloudRunServiceTemplate;
    traffic(index: string): DataGoogleCloudRunServiceTraffic;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
