import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleCloudIdentityGroupsConfig extends cdktf.TerraformMetaArguments {
    /**
     * The resource name of the entity under which this Group resides in the Cloud Identity resource hierarchy.
     *
     * Must be of the form identitysources/{identity_source_id} for external-identity-mapped
     * groups or customers/{customer_id} for Google Groups.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloud_identity_groups.html#parent DataGoogleCloudIdentityGroups#parent}
     */
    readonly parent: string;
}
export declare class DataGoogleCloudIdentityGroupsGroupsGroupKey extends cdktf.ComplexComputedList {
    get id(): string;
    get namespace(): string;
}
export declare class DataGoogleCloudIdentityGroupsGroups extends cdktf.ComplexComputedList {
    get createTime(): string;
    get description(): string;
    get displayName(): string;
    get groupKey(): any;
    get initialGroupConfig(): string;
    get labels(): any;
    get name(): string;
    get parent(): string;
    get updateTime(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/cloud_identity_groups.html google_cloud_identity_groups}.
 */
export declare class DataGoogleCloudIdentityGroups extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/cloud_identity_groups.html google_cloud_identity_groups} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleCloudIdentityGroupsConfig);
    groups(index: string): DataGoogleCloudIdentityGroupsGroups;
    get id(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
