import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleCloudIdentityGroupMembershipsConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Group to get memberships from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloud_identity_group_memberships.html#group DataGoogleCloudIdentityGroupMemberships#group}
     */
    readonly group: string;
}
export declare class DataGoogleCloudIdentityGroupMembershipsMembershipsPreferredMemberKey extends cdktf.ComplexComputedList {
    get id(): string;
    get namespace(): string;
}
export declare class DataGoogleCloudIdentityGroupMembershipsMembershipsRoles extends cdktf.ComplexComputedList {
    get name(): string;
}
export declare class DataGoogleCloudIdentityGroupMembershipsMemberships extends cdktf.ComplexComputedList {
    get createTime(): string;
    get group(): string;
    get name(): string;
    get preferredMemberKey(): any;
    get roles(): any;
    get type(): string;
    get updateTime(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/cloud_identity_group_memberships.html google_cloud_identity_group_memberships}.
 */
export declare class DataGoogleCloudIdentityGroupMemberships extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/cloud_identity_group_memberships.html google_cloud_identity_group_memberships} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleCloudIdentityGroupMembershipsConfig);
    private _group?;
    get group(): string;
    set group(value: string);
    get groupInput(): string | undefined;
    get id(): string;
    memberships(index: string): DataGoogleCloudIdentityGroupMembershipsMemberships;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
