import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleBillingAccountConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/billing_account.html#billing_account DataGoogleBillingAccount#billing_account}.
     */
    readonly billingAccount?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/billing_account.html#display_name DataGoogleBillingAccount#display_name}.
     */
    readonly displayName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/billing_account.html#open DataGoogleBillingAccount#open}.
     */
    readonly open?: boolean | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/billing_account.html google_billing_account}.
 */
export declare class DataGoogleBillingAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/billing_account.html google_billing_account} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: DataGoogleBillingAccountConfig);
    private _billingAccount?;
    get billingAccount(): string | undefined;
    set billingAccount(value: string | undefined);
    resetBillingAccount(): void;
    get billingAccountInput(): string | undefined;
    private _displayName?;
    get displayName(): string | undefined;
    set displayName(value: string | undefined);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _open?;
    get open(): boolean | cdktf.IResolvable | undefined;
    set open(value: boolean | cdktf.IResolvable | undefined);
    resetOpen(): void;
    get openInput(): boolean | cdktf.IResolvable | undefined;
    get projectIds(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
