import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataCatalogTagConfig extends cdktf.TerraformMetaArguments {
    /**
     * Resources like Entry can have schemas associated with them.
     *
     * This scope allows users to attach tags to an
     * individual column based on that schema.
     *
     * For attaching a tag to a nested column, use '.' to separate the column names. Example:
     * 'outer_column.inner_column'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#column DataCatalogTag#column}
     */
    readonly column?: string;
    /**
     * The name of the parent this tag is attached to.
     *
     * This can be the name of an entry or an entry group. If an entry group, the tag will be attached to
     * all entries in that group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#parent DataCatalogTag#parent}
     */
    readonly parent?: string;
    /**
     * The resource name of the tag template that this tag uses. Example: projects/{project_id}/locations/{location}/tagTemplates/{tagTemplateId} This field cannot be modified after creation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#template DataCatalogTag#template}
     */
    readonly template: string;
    /**
     * fields block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#fields DataCatalogTag#fields}
     */
    readonly fields: DataCatalogTagFields[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#timeouts DataCatalogTag#timeouts}
     */
    readonly timeouts?: DataCatalogTagTimeouts;
}
export interface DataCatalogTagFields {
    /**
     * Holds the value for a tag field with boolean type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#bool_value DataCatalogTag#bool_value}
     */
    readonly boolValue?: boolean | cdktf.IResolvable;
    /**
     * Holds the value for a tag field with double type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#double_value DataCatalogTag#double_value}
     */
    readonly doubleValue?: number;
    /**
     * The display name of the enum value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#enum_value DataCatalogTag#enum_value}
     */
    readonly enumValue?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#field_name DataCatalogTag#field_name}.
     */
    readonly fieldName: string;
    /**
     * Holds the value for a tag field with string type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#string_value DataCatalogTag#string_value}
     */
    readonly stringValue?: string;
    /**
     * Holds the value for a tag field with timestamp type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#timestamp_value DataCatalogTag#timestamp_value}
     */
    readonly timestampValue?: string;
}
export interface DataCatalogTagTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#create DataCatalogTag#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#delete DataCatalogTag#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html#update DataCatalogTag#update}.
     */
    readonly update?: string;
}
export declare class DataCatalogTagTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html google_data_catalog_tag}.
 */
export declare class DataCatalogTag extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag.html google_data_catalog_tag} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataCatalogTagConfig);
    private _column?;
    get column(): string | undefined;
    set column(value: string | undefined);
    resetColumn(): void;
    get columnInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _parent?;
    get parent(): string | undefined;
    set parent(value: string | undefined);
    resetParent(): void;
    get parentInput(): string | undefined;
    private _template?;
    get template(): string;
    set template(value: string);
    get templateInput(): string | undefined;
    get templateDisplayname(): string;
    private _fields?;
    get fields(): DataCatalogTagFields[];
    set fields(value: DataCatalogTagFields[]);
    get fieldsInput(): DataCatalogTagFields[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): DataCatalogTagTimeoutsOutputReference;
    putTimeouts(value: DataCatalogTagTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataCatalogTagTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
