import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataCatalogEntryConfig extends cdktf.TerraformMetaArguments {
    /**
     * Entry description, which can consist of several sentences or paragraphs that describe entry contents.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry.html#description DataCatalogEntry#description}
     */
    readonly description?: string;
    /**
     * Display information such as title and description.
     *
     * A short name to identify the entry,
     * for example, "Analytics Data - Jan 2011".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry.html#display_name DataCatalogEntry#display_name}
     */
    readonly displayName?: string;
    /**
     * The name of the entry group this entry is in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry.html#entry_group DataCatalogEntry#entry_group}
     */
    readonly entryGroup: string;
    /**
     * The id of the entry to create.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry.html#entry_id DataCatalogEntry#entry_id}
     */
    readonly entryId: string;
    /**
     * The resource this metadata entry refers to.
     *
     * For Google Cloud Platform resources, linkedResource is the full name of the resource.
     * For example, the linkedResource for a table resource from BigQuery is:
     * //bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId
     * Output only when Entry is of type in the EntryType enum. For entries with userSpecifiedType,
     * this field is optional and defaults to an empty string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry.html#linked_resource DataCatalogEntry#linked_resource}
     */
    readonly linkedResource?: string;
    /**
     * Schema of the entry (e.g. BigQuery, GoogleSQL, Avro schema), as a json string. An entry might not have any schema attached to it. See https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries#schema for what fields this schema can contain.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry.html#schema DataCatalogEntry#schema}
     */
    readonly schema?: string;
    /**
     * The type of the entry.
     *
     * Only used for Entries with types in the EntryType enum.
     * Currently, only FILESET enum value is allowed. All other entries created through Data Catalog must use userSpecifiedType. Possible values: ["FILESET"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry.html#type DataCatalogEntry#type}
     */
    readonly type?: string;
    /**
     * This field indicates the entry's source system that Data Catalog does not integrate with.
     *
     * userSpecifiedSystem strings must begin with a letter or underscore and can only contain letters, numbers,
     * and underscores; are case insensitive; must be at least 1 character and at most 64 characters long.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry.html#user_specified_system DataCatalogEntry#user_specified_system}
     */
    readonly userSpecifiedSystem?: string;
    /**
     * Entry type if it does not fit any of the input-allowed values listed in EntryType enum above.
     *
     * When creating an entry, users should check the enum values first, if nothing matches the entry
     * to be created, then provide a custom value, for example "my_special_type".
     * userSpecifiedType strings must begin with a letter or underscore and can only contain letters,
     * numbers, and underscores; are case insensitive; must be at least 1 character and at most 64 characters long.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry.html#user_specified_type DataCatalogEntry#user_specified_type}
     */
    readonly userSpecifiedType?: string;
    /**
     * gcs_fileset_spec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry.html#gcs_fileset_spec DataCatalogEntry#gcs_fileset_spec}
     */
    readonly gcsFilesetSpec?: DataCatalogEntryGcsFilesetSpec;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry.html#timeouts DataCatalogEntry#timeouts}
     */
    readonly timeouts?: DataCatalogEntryTimeouts;
}
export declare class DataCatalogEntryBigqueryDateShardedSpec extends cdktf.ComplexComputedList {
    get dataset(): string;
    get shardCount(): number;
    get tablePrefix(): string;
}
export declare class DataCatalogEntryBigqueryTableSpecTableSpec extends cdktf.ComplexComputedList {
    get groupedEntry(): string;
}
export declare class DataCatalogEntryBigqueryTableSpecViewSpec extends cdktf.ComplexComputedList {
    get viewQuery(): string;
}
export declare class DataCatalogEntryBigqueryTableSpec extends cdktf.ComplexComputedList {
    get tableSourceType(): string;
    get tableSpec(): any;
    get viewSpec(): any;
}
export interface DataCatalogEntryGcsFilesetSpec {
    /**
     * Patterns to identify a set of files in Google Cloud Storage.
     *
     * See [Cloud Storage documentation](https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames)
     * for more information. Note that bucket wildcards are currently not supported. Examples of valid filePatterns:
     *
     * gs://bucket_name/dir/*: matches all files within bucket_name/dir directory.
     * gs://bucket_name/dir/**: matches all files in bucket_name/dir spanning all subdirectories.
     * gs://bucket_name/file*: matches files prefixed by file in bucket_name
     * gs://bucket_name/??.txt: matches files with two characters followed by .txt in bucket_name
     * gs://bucket_name/[aeiou].txt: matches files that contain a single vowel character followed by .txt in bucket_name
     * gs://bucket_name/[a-m].txt: matches files that contain a, b, ... or m followed by .txt in bucket_name
     * gs://bucket_name/a/*\/b: matches all files in bucket_name that match a/*\/b pattern, such as a/c/b, a/d/b
     * gs://another_bucket/a.txt: matches gs://another_bucket/a.txt
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry.html#file_patterns DataCatalogEntry#file_patterns}
     */
    readonly filePatterns: string[];
}
export declare class DataCatalogEntryGcsFilesetSpecOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _filePatterns?;
    get filePatterns(): string[];
    set filePatterns(value: string[]);
    get filePatternsInput(): string[] | undefined;
}
export interface DataCatalogEntryTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry.html#create DataCatalogEntry#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry.html#delete DataCatalogEntry#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry.html#update DataCatalogEntry#update}.
     */
    readonly update?: string;
}
export declare class DataCatalogEntryTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry.html google_data_catalog_entry}.
 */
export declare class DataCatalogEntry extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry.html google_data_catalog_entry} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataCatalogEntryConfig);
    bigqueryDateShardedSpec(index: string): DataCatalogEntryBigqueryDateShardedSpec;
    bigqueryTableSpec(index: string): DataCatalogEntryBigqueryTableSpec;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string | undefined;
    set displayName(value: string | undefined);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _entryGroup?;
    get entryGroup(): string;
    set entryGroup(value: string);
    get entryGroupInput(): string | undefined;
    private _entryId?;
    get entryId(): string;
    set entryId(value: string);
    get entryIdInput(): string | undefined;
    get id(): string;
    get integratedSystem(): string;
    private _linkedResource?;
    get linkedResource(): string | undefined;
    set linkedResource(value: string | undefined);
    resetLinkedResource(): void;
    get linkedResourceInput(): string | undefined;
    get name(): string;
    private _schema?;
    get schema(): string | undefined;
    set schema(value: string | undefined);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    private _type?;
    get type(): string | undefined;
    set type(value: string | undefined);
    resetType(): void;
    get typeInput(): string | undefined;
    private _userSpecifiedSystem?;
    get userSpecifiedSystem(): string | undefined;
    set userSpecifiedSystem(value: string | undefined);
    resetUserSpecifiedSystem(): void;
    get userSpecifiedSystemInput(): string | undefined;
    private _userSpecifiedType?;
    get userSpecifiedType(): string | undefined;
    set userSpecifiedType(value: string | undefined);
    resetUserSpecifiedType(): void;
    get userSpecifiedTypeInput(): string | undefined;
    private _gcsFilesetSpec?;
    private __gcsFilesetSpecOutput;
    get gcsFilesetSpec(): DataCatalogEntryGcsFilesetSpecOutputReference;
    putGcsFilesetSpec(value: DataCatalogEntryGcsFilesetSpec | undefined): void;
    resetGcsFilesetSpec(): void;
    get gcsFilesetSpecInput(): DataCatalogEntryGcsFilesetSpec | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): DataCatalogEntryTimeoutsOutputReference;
    putTimeouts(value: DataCatalogEntryTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataCatalogEntryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
