import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataCatalogEntryGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Entry group description, which can consist of several sentences or paragraphs that describe entry group contents.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group.html#description DataCatalogEntryGroup#description}
     */
    readonly description?: string;
    /**
     * A short name to identify the entry group, for example, "analytics data - jan 2011".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group.html#display_name DataCatalogEntryGroup#display_name}
     */
    readonly displayName?: string;
    /**
     * The id of the entry group to create.
     *
     * The id must begin with a letter or underscore,
     * contain only English letters, numbers and underscores, and be at most 64 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group.html#entry_group_id DataCatalogEntryGroup#entry_group_id}
     */
    readonly entryGroupId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group.html#project DataCatalogEntryGroup#project}.
     */
    readonly project?: string;
    /**
     * EntryGroup location region.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group.html#region DataCatalogEntryGroup#region}
     */
    readonly region?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group.html#timeouts DataCatalogEntryGroup#timeouts}
     */
    readonly timeouts?: DataCatalogEntryGroupTimeouts;
}
export interface DataCatalogEntryGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group.html#create DataCatalogEntryGroup#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group.html#delete DataCatalogEntryGroup#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group.html#update DataCatalogEntryGroup#update}.
     */
    readonly update?: string;
}
export declare class DataCatalogEntryGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group.html google_data_catalog_entry_group}.
 */
export declare class DataCatalogEntryGroup extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry_group.html google_data_catalog_entry_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataCatalogEntryGroupConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string | undefined;
    set displayName(value: string | undefined);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _entryGroupId?;
    get entryGroupId(): string;
    set entryGroupId(value: string);
    get entryGroupIdInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): DataCatalogEntryGroupTimeoutsOutputReference;
    putTimeouts(value: DataCatalogEntryGroupTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataCatalogEntryGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
